% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_auth.R
\name{drive_auth_configure}
\alias{drive_auth_configure}
\alias{drive_api_key}
\alias{drive_oauth_app}
\title{Edit and view auth configuration}
\usage{
drive_auth_configure(app, path, api_key)

drive_api_key()

drive_oauth_app()
}
\arguments{
\item{app}{OAuth app, in the sense of \code{\link[httr:oauth_app]{httr::oauth_app()}}.}

\item{path}{JSON downloaded from Google Cloud Platform Console, containing a
client id (aka key) and secret, in one of the forms supported for the \code{txt}
argument of \code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} (typically, a file path or JSON string).}

\item{api_key}{API key.}
}
\value{
\itemize{
\item \code{drive_auth_configure()}: An object of R6 class
\link[gargle:AuthState]{gargle::AuthState}, invisibly.
\item \code{drive_oauth_app()}: the current user-configured
\code{\link[httr:oauth_app]{httr::oauth_app()}}.
\item \code{drive_api_key()}: the current user-configured API key.
}
}
\description{
These functions give more control over and visibility into the auth
configuration than \code{\link[=drive_auth]{drive_auth()}} does. \code{drive_auth_configure()}
lets the user specify their own:
\itemize{
\item OAuth app, which is used when obtaining a user token.
\item API key. If googledrive is de-authorized via \code{\link[=drive_deauth]{drive_deauth()}}, all
requests are sent with an API key in lieu of a token.
See the vignette
\href{https://gargle.r-lib.org/articles/get-api-credentials.html}{How to get your own API credentials}
for more.
If the user does not configure these settings, internal defaults
are used.
\code{drive_oauth_app()} and \code{drive_api_key()} retrieve the
currently configured OAuth app and API key, respectively.
}
}
\examples{
# see and store the current user-configured OAuth app (probaby `NULL`)
(original_app <- drive_oauth_app())

# see and store the current user-configured API key (probaby `NULL`)
(original_api_key <- drive_api_key())

if (require(httr)) {
  # bring your own app via client id (aka key) and secret
  google_app <- httr::oauth_app(
    "my-awesome-google-api-wrapping-package",
    key = "123456789.apps.googleusercontent.com",
    secret = "abcdefghijklmnopqrstuvwxyz"
  )
  google_key <- "the-key-I-got-for-a-google-API"
  drive_auth_configure(app = google_app, api_key = google_key)

  # confirm the changes
  drive_oauth_app()
  drive_api_key()
}

\dontrun{
## bring your own app via JSON downloaded from Google Developers Console
drive_auth_configure(
  path = "/path/to/the/JSON/you/downloaded/from/google/dev/console.json"
)
}

# restore original auth config
drive_auth_configure(app = original_app, api_key = original_api_key)
}
\seealso{
Other auth functions: 
\code{\link{drive_auth}()},
\code{\link{drive_deauth}()}
}
\concept{auth functions}
