% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_generate.R
\name{request_generate}
\alias{request_generate}
\title{Build a request for the Google Drive API}
\usage{
request_generate(
  endpoint = character(),
  params = list(),
  key = NULL,
  token = drive_token()
)
}
\arguments{
\item{endpoint}{Character. Nickname for one of the selected Drive v3 API
endpoints built into googledrive. Learn more in \code{\link[=drive_endpoints]{drive_endpoints()}}.}

\item{params}{Named list. Parameters destined for endpoint URL substitution,
the query, or the body.}

\item{key}{API key. Needed for requests that don't contain a token. The need
for an API key in the absence of a token is explained in Google's document
"Credentials, access, security, and identity"
(\verb{https://support.google.com/googleapi/answer/6158857?hl=en&ref_topic=7013279}).
In order of precedence, these sources are consulted: the formal \code{key}
argument, a \code{key} parameter in \code{params}, a user-configured API key fetched
via \code{\link[=drive_api_key]{drive_api_key()}}, a built-in key shipped with googledrive. See
\code{\link[=drive_auth_configure]{drive_auth_configure()}} for details on a user-configured key.}

\item{token}{Drive token. Set to \code{NULL} to suppress the inclusion of a token.
Note that, if auth has been de-activated via \code{\link[=drive_deauth]{drive_deauth()}},
\code{drive_token()} will actually return \code{NULL}.}
}
\value{
\code{list()}\cr Components are \code{method}, \code{path}, \code{query}, \code{body},
\code{token}, and \code{url}, suitable as input for \code{\link[=request_make]{request_make()}}.
}
\description{
Build a request, using knowledge of the \href{https://developers.google.com/drive/api/v3/about-sdk}{Drive v3 API} from its
Discovery Document
(\verb{https://www.googleapis.com/discovery/v1/apis/drive/v3/rest}). Most users
should, instead, use higher-level wrappers that facilitate common tasks,
such as uploading or downloading Drive files. The functions here are
intended for internal use and for programming around the Drive API.

\code{request_generate()} lets you provide the bare minimum of input.
It takes a nickname for an endpoint and:
\itemize{
\item Uses the API spec to look up the \code{path}, \code{method}, and base URL.
\item Checks \code{params} for validity and completeness with respect to the
endpoint. Separates parameters into those destined for the body, the query,
and URL endpoint substitution (which is also enacted).
\item Adds an API key to the query if and only if \code{token = NULL}.
\item Adds \code{supportsAllDrives = TRUE} to the query if the endpoint requires.
}
}
\examples{
\dontshow{if (drive_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
req <- request_generate(
  "drive.files.get",
  list(fileId = "abc"),
  token = drive_token()
)
req
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[gargle:request_develop]{gargle::request_develop()}}, \code{\link[gargle:request_develop]{gargle::request_build()}}

Other low-level API functions: 
\code{\link{drive_has_token}()},
\code{\link{drive_token}()},
\code{\link{request_make}()}
}
\concept{low-level API functions}
