% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gs_read_listfeed.R
\name{gs_read_listfeed}
\alias{gs_read_listfeed}
\title{Read data via the "list feed"}
\usage{
gs_read_listfeed(ss, ws = 1, verbose = TRUE)
}
\arguments{
\item{ss}{a registered Google spreadsheet, i.e. a \code{\link{googlesheet}}
object}

\item{ws}{positive integer or character string specifying index or title,
respectively, of the worksheet}

\item{verbose}{logical; do you want informative messages?}
}
\value{
a tbl_df
}
\description{
Gets data via the "list feed", which assumes populated cells form a neat
rectangle. The list feed consumes data row by row. The first row is assumed
to hold variable or column names. The related function,
\code{\link{gs_read_csv}}, also returns data from a rectangle of cells,
but it is generally faster and more resilient to, e.g. empty rows, so use it
if you can. However, you may need to use this function if you are dealing
with an "old" Google Sheet, which \code{\link{gs_read_csv}} does not
support). Consult the Google Sheets API documentation for more details about
\href{https://developers.google.com/google-apps/spreadsheets/data#work_with_list-based_feeds}{the
"list feed"}.
}
\note{
When you use the "list feed", the Sheets API transforms the variable or
  column names like so: 'The column names are the header values of the
  worksheet lowercased and with all non-alpha-numeric characters removed. For
  example, if the cell A1 contains the value "Time 2 Eat!" the column name
  would be "time2eat".' If this is intolerable to you, use a different
  function to read the data. Or, at least, consume the first row via the cell
  feed and manually restore the variable names \emph{post hoc}.
}
\examples{
\dontrun{
gap_ss <- gs_gap() # register the Gapminder example sheet
oceania_lf <- gs_read_listfeed(gap_ss, ws = "Oceania")
str(oceania_lf)
oceania_lf
}
}
\seealso{
Other data.consumption.functions: \code{\link{gs_read_cellfeed}};
  \code{\link{gs_read_csv}}; \code{\link{gs_read}};
  \code{\link{gs_reshape_cellfeed}};
  \code{\link{gs_simplify_cellfeed}}
}

