% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sheets_auth.R
\name{sheets_token}
\alias{sheets_token}
\title{Produce configured token}
\usage{
sheets_token()
}
\value{
A \code{request} object (an S3 class provided by \link[httr:httr]{httr}).
}
\description{
For internal use or for those programming around the Sheets API.
Returns a token pre-processed with \code{\link[httr:config]{httr::config()}}. Most users
do not need to handle tokens "by hand" or, even if they need some
control, \code{\link[=sheets_auth]{sheets_auth()}} is what they need. If there is no current
token, \code{\link[=sheets_auth]{sheets_auth()}} is called to either load from cache or
initiate OAuth2.0 flow.
If auth has been deactivated via \code{\link[=sheets_deauth]{sheets_deauth()}}, \code{sheets_token()}
returns \code{NULL}.
}
\examples{
if (sheets_has_token()) {
  req <- request_generate(
    "sheets.spreadsheets.get",
    list(spreadsheetId = "abc"),
    token = sheets_token()
  )
  req
}
}
\seealso{
Other low-level API functions: 
\code{\link{request_generate}()},
\code{\link{request_make}()},
\code{\link{sheets_has_token}()}
}
\concept{low-level API functions}
