% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_make_raster_from_grid.R
\name{gt_make_raster_from_grid}
\alias{gt_make_raster_from_grid}
\title{Make Google Traffic Raster Based on Grid of Coordinates}
\usage{
gt_make_raster_from_grid(
  grid_param_df,
  google_key,
  webshot_delay = NULL,
  return_list_of_rasters = FALSE,
  print_progress = TRUE
)
}
\arguments{
\item{grid_param_df}{Grid parameter dataframe produced from \code{\link[=gt_make_grid]{gt_make_grid()}}}

\item{google_key}{Google API key}

\item{webshot_delay}{How long to wait for Google traffic layer to render. Larger height/widths require longer delay times. If \code{NULL}, the following delay time (in seconds) is used: \code{delay = max(height,width)/200}.}

\item{return_list_of_rasters}{Instead of merging traffic rasters produced for each grid together into one large raster, return a list of rasters (default: \code{FALSE})}

\item{print_progress}{Whether to print function progress (default: \code{TRUE})}
}
\value{
Returns a georeferenced raster. Raster pixels can contain the following values: 1 = no traffic; 2 = medium traffic; 3 = high traffic; 4 = heavy traffic.
}
\description{
Make a raster from Google traffic data, where each pixel has one of four values
indicating traffic volume (no traffic, light, moderate, and heavy).
}
\examples{
\dontrun{
## Grab polygon of Manhattan
us_sp <- raster::getData('GADM', country='USA', level=2)
ny_sp <- us_sp[us_sp$NAME_2 \%in\% "New York",]

## Make Grid
grid_df <- gt_make_grid(polygon = ny_sp,
                       height   = 2000,
                       width    = 2000,
                       zoom     = 16)

## Make raster from grid                        
r <- gt_make_raster_from_grid(grid_param_df = grid_clean_df,
                              google_key    = "GOOGLE-KEY-HERE")
}

}
