% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_make_png.R
\name{gt_make_png}
\alias{gt_make_png}
\title{Make Google Traffic PNG}
\usage{
gt_make_png(
  location,
  height,
  width,
  zoom,
  out_filename,
  google_key,
  webshot_zoom = 1,
  webshot_delay = NULL,
  print_progress = TRUE
)
}
\arguments{
\item{location}{Vector of latitude and longitude}

\item{height}{Height (in pixels; pixel length depends on zoom)}

\item{width}{Width (in pixels; pixel length depends on zoom)}

\item{zoom}{Zoom level; integer from 5 to 20. For more information about how zoom levels correspond to pixel size, see \href{https://wiki.openstreetmap.org/wiki/Zoom_levels}{here} and \href{https://developers.google.com/maps/documentation/javascript/overview#zoom-levels}{here}.}

\item{out_filename}{Filename of PNG file to make}

\item{google_key}{Google API key, where the \href{https://developers.google.com/maps/documentation/javascript/overview}{Maps JavaScript API} is enabled. To create a Google API key, follow \href{https://developers.google.com/maps/get-started#create-project}{these instructions}.}

\item{webshot_zoom}{How many pixels should be created relative to height and width values. If \code{height} and \code{width} are set to \code{100} and \code{webshot_zoom} is set to \code{2}, the resulting raster will have dimensions of about \verb{200x200} (default: \code{1}).}

\item{webshot_delay}{How long to wait for Google traffic layer to render. Larger height/widths require longer delay times. If \code{NULL}, the following delay time (in seconds) is used: \code{delay = max(height,width)/200}.}

\item{print_progress}{Whether to print function progress (default: \code{TRUE})}
}
\value{
Returns a PNG file showing traffic levels.
}
\description{
Make a png file of \href{https://developers.google.com/maps/documentation/javascript/trafficlayer}{Google traffic data}. The \code{\link[=gt_load_png_as_traffic_raster]{gt_load_png_as_traffic_raster()}} function can then
be used to convert the png into a traffic raster
}
\examples{
\dontrun{
gt_make_png(location     = c(40.712778, -74.006111),
            height       = 1000,
            width        = 1000,
            zoom         = 16,
            out_filename = "google_traffic.png",
            google_key   = "GOOGLE-KEY-HERE")
}

}
\references{
Markus Hilpert, Jenni A. Shearston, Jemaleddin Cole, Steven N. Chillrud, and Micaela E. Martinez. \href{https://arxiv.org/abs/2105.12235}{Acquisition and analysis of crowd-sourced traffic data}. CoRR, abs/2105.12235, 2021.

Pavel Pokorny. \href{https://ieeexplore.ieee.org/abstract/document/8326831}{Determining traffic levels in cities using google maps}. In 2017 Fourth International Conference on Mathematics and Computers in Sciences and in Industry (MCSI), pages 144–147, 2017.
}
