% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_map_layers.R
\name{add_heatmap}
\alias{add_heatmap}
\title{Add heatmap}
\usage{
add_heatmap(map, data = get_map_data(map), lat = NULL, lon = NULL,
  weight = NULL, option_gradient = NULL, option_dissipating = FALSE,
  option_radius = 0.01, option_opacity = 0.6, layer_id = NULL)
}
\arguments{
\item{map}{a googleway map object created from \code{google_map()}}

\item{data}{data frame containing at least two columns, one specifying the
latitude coordinates, and the other specifying the longitude. If Null, the
data passed into \code{google_map()} will be used.}

\item{lat}{string specifying the column of \code{data} containing the 'latitude'
coordinates. If left NULL, a best-guess will be made}

\item{lon}{string specifying the column of \code{data} containing the 'longitude'
coordinates. If left NULL, a best-guess will be made}

\item{weight}{string specifying the column of \code{data} containing the 'weight'
associated with each point. If NULL, each point will get a weight of 1.}

\item{option_gradient}{vector of colours to use as the gradient colours. see Details}

\item{option_dissipating}{logical Specifies whether heatmaps dissipate on zoom.
When dissipating is FALSE the radius of influence increases with zoom level to
ensure that the color intensity is preserved at any given geographic location.
Defaults to FALSE}

\item{option_radius}{numeric. The radius of influence for each data point, in pixels.}

\item{option_opacity}{The opacity of the heatmap, expressed as a number between
0 and 1. Defaults to 0.6.}

\item{layer_id}{single value specifying an id for the layer.}
}
\description{
Adds a heatmap to a google map
}
\details{
\code{option_gradient} colours can be two of the R colour specifications;
either a colour name (as listed by \code{colors()}, or a hexadecimal string of the
form \code{"#rrggbb"}).
The first colour in the vector will be used as the colour that fades to transparent,
while the last colour in the vector will be use in the centre of the 'heat'.
}
\examples{
\dontrun{

map_key <- 'your_api_key'

set.seed(20170417)
df <- tram_route
df$weight <- sample(1:10, size = nrow(df), replace = T)

google_map(key = map_key, data = df) \%>\%
 add_heatmap(lat = "shape_pt_lat", lon = "shape_pt_lon", weight = "weight",
              option_radius = 0.001)

## specifying different colour gradient
option_gradient <- c('orange', 'blue', 'mediumpurple4', 'snow4', 'thistle1')

google_map(key = map_key, data = df) \%>\%
 add_heatmap(lat = "shape_pt_lat", lon = "shape_pt_lon", weight = "weight",
              option_radius = 0.001, option_gradient = option_gradient)

 }
}

