% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_roads.R
\name{google_snapToRoads}
\alias{google_snapToRoads}
\title{Snap To Roads}
\usage{
google_snapToRoads(df_path, lat = NULL, lon = NULL, interpolate = FALSE,
  simplify = TRUE, key)
}
\arguments{
\item{df_path}{\code{data.frame} with at least two columns specifying the latitude & longitude coordinates,
with a maximum of 100 pairs of coordinates.}

\item{lat}{string specifying the column of \code{df_path} containing the
'latitude' coordinates. If left NULL, a best-guess will be made.}

\item{lon}{string specifying the column of \code{df_path} containing the '
longitude' coordinates. If left NULL, a best-guess will be made.}

\item{interpolate}{logical indicating whether to interpolate a path to
include all points forming the full road-geometry.
When \code{TRUE}, additional interpolated points will also be returned, resulting in a path
that smoothly follows the geometry of the road, even around corners and through
tunnels. Interpolated paths will most likely contain more ponts that the original path.}

\item{simplify}{\code{logical} Indicates if the returned JSON should be coerced into a list}

\item{key}{\code{string} A valid Google Developers Places API key}
}
\description{
Takes up to 100 GPS coordinates collected along a route and returns a similar set of data,
with the points snapped to the most likely roads the vehicle was treveling along
}
\note{
The snapping algorithm works best for points that are not too far apart.
If you observe odd snapping behaviour, try creating paths that have points closer together.
To ensure the best snap-to-road quality, you should aim to provide paths on which consecutive
pairs of points are within 300m of each other. This will also help in handling any
isolated, long jumps between consecutive points caused by GPS signal loss or noise.
}
\examples{
\dontrun{

key <- 'your_api_key'

df_path <- read.table(text = "lat lon
-35.27801 149.12958
-35.28032 149.12907
-35.28099 149.12929
-35.28144 149.12984
-35.28194 149.13003
-35.28282 149.12956
-35.28302 149.12881
-35.28473 149.12836", header = T)

google_snapToRoads(df_path, key = key, interpolate = TRUE, simplify = TRUE)


}
}
\seealso{
\link{google_nearestRoads}
}

