% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_map_layers.R
\name{update_rectangles}
\alias{update_rectangles}
\title{Update rectangles}
\usage{
update_rectangles(map, data, id, draggable = NULL, stroke_colour = NULL,
  stroke_weight = NULL, stroke_opacity = NULL, fill_colour = NULL,
  fill_opacity = NULL, layer_id = NULL)
}
\arguments{
\item{map}{a googleway map object created from \code{google_map()}}

\item{data}{data.frame containing the new values for the rectangles}

\item{id}{string representing the column of \code{data} containing the id values
for the rectangles The id values must be present in the data supplied to
\code{add_rectangles} in order for the polygons to be udpated}

\item{draggable}{string specifying the column of \code{data} defining if the
rectangle is 'draggable' (either TRUE or FALSE)}

\item{stroke_colour}{either a string specifying the column of \code{data} containing
the stroke colour of each rectangle, or a valid hexadecimal numeric HTML style
to be applied to all the rectangles}

\item{stroke_weight}{either a string specifying the column of \code{data} containing
the stroke weight of each rectangle, or a number indicating the width of pixels
in the line to be applied to all the rectangles}

\item{stroke_opacity}{either a string specifying the column of \code{data} containing
the stroke opacity of each rectangle, or a value between 0 and 1 that will be
applied to all the rectangles}

\item{fill_colour}{either a string specifying the column of \code{data} containing
the fill colour of each rectangle, or a valid hexadecimal numeric HTML style to
be applied to all the cirlces}

\item{fill_opacity}{either a string specifying the column of \code{data} containing
the fill opacity of each rectangle, or a value between 0 and 1 that will be applied
to all the rectangles}

\item{layer_id}{single value specifying an id for the layer.}
}
\description{
Updates specific colours and opacities of specified rectangles Designed to be
used in a shiny application.
}
\note{
Any rectangles (as specified by the \code{id} argument) that do not exist
in the \code{data} passed into \code{add_rectangles()} will not be added to the map.
This function will only update the rectangles that currently exist on the map when
the function is called.
}

