% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ai_assistant.R
\name{goose_review_code}
\alias{goose_review_code}
\title{Review R Code with AI}
\usage{
goose_review_code(
  code,
  focus = c("performance", "style", "bugs", "documentation"),
  context = NULL,
  detailed = TRUE
)
}
\arguments{
\item{code}{Character string or function containing R code to review}

\item{focus}{Character vector of focus areas (e.g., "performance", "style", "bugs")}

\item{context}{Optional context about the code's purpose}

\item{detailed}{Logical, whether to request detailed analysis}
}
\value{
List with review results including suggestions, issues, and improvements
}
\description{
Get AI-powered code review and suggestions for improvement.
}
\examples{
\dontrun{
# Review a function
my_func <- function(x) {
  for(i in 1:length(x)) {
    x[i] <- x[i] * 2
  }
  return(x)
}
review <- goose_review_code(my_func, focus = c("performance", "style"))

# Review code string
code <- "df$new_col = df$col1 + df$col2"
review <- goose_review_code(code, context = "Adding columns in data frame")
}
}
