% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10-grafos-TSP.R
\encoding{UTF-8}
\name{perturb_tour_4exc}
\alias{perturb_tour_4exc}
\title{Random 4-exchange transformation}
\usage{
perturb_tour_4exc(C, V, n)
}
\arguments{
\item{C}{Cycle to be 4-exchanged}

\item{V}{1:n list, positions to draw from}

\item{n}{Number of vertices of the cycle}
}
\value{
The 4-exchanged cycle.
}
\description{
It performs a random 4-exchange transformation to a cycle.
}
\details{
The transformation is carried out by randomly selecting four
non-mutually incident edges from the cycle.  Upon eliminating
these four edges, we obtain four pieces ci of the original
cycle.  The 4-exchanged cycle is c1, c4, c3, c2.  This is a
typical 4-exchange which cannot be constructed using
2-exchanges and therefore it is used by local search routines
as an escape from 2-opt local minima.
}
\examples{
set.seed(1)
perturb_tour_4exc(1:9, 1:9, 9)   # 2 3 9 1 7 8 4 5 6

}
\author{
Cesar Asensio
}
