% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orlmSet.R
\name{orlmSet}
\alias{orlmSet}
\title{Set of multivariate regression models}
\usage{
orlmSet(formula, data, set, direction = "increase", n = NULL, base = 1,
  control = orlmcontrol())
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment(formula), typically the environment from which lm is called.}

\item{set}{either a character string (see \code{\link{constrSet}}), or a list with slots for constr, rhs, and nec similarly defined as in \code{\link{orlm}}}

\item{direction}{direction of the order constraints}

\item{n}{a (possibly named) vector of sample sizes for each group}

\item{base}{column of the constraint matrix representing a control group}

\item{control}{a list of control arguments; see \code{\link{orlmcontrol}} for details.}
}
\value{
a list with orlm objects
}
\description{
Fitting a specific set of multivariate regression models with order restrictions.
}
\details{
This function is just a wrapper for repeated calls of \code{\link{orlm}} with different constraint definitions. Predefined lists with constraint-sets can be constructed with function \code{\link{constrSet}}.
}
\examples{
########################
## Artificial example ##
########################

n <- 10
m <- c(1,2,4,5,2,1)
nm <- length(m)
dat <- data.frame(grp=as.factor(rep(1:nm, each=n)),
                  y=rnorm(n*nm, rep(m, each=n), 1))

(cs <- constrSet(table(dat$grp), set="sequence"))
(oss <- orlmSet(y ~ grp-1, data=dat, set=cs))

# the same as:
oss <- orlmSet(y ~ grp-1, data=dat, set="sequence")
}
\seealso{
\code{\link{orlm}}, \code{\link{constrSet}}, \code{\link{goric}}
}
\keyword{models}
