% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gower.R
\name{influence.gower}
\alias{influence.gower}
\title{Compute DFBETAs for units and/or coders.}
\usage{
\method{influence}{gower}(model, units, coders, ...)
}
\arguments{
\item{model}{a fitted model object, the result of a call to \code{\link{gower.agree}}.}

\item{units}{a vector of integers. A DFBETA will be computed for each of the corresponding units.}

\item{coders}{a vector of integers. A DFBETA will be computed for each of the corresponding coders.}

\item{...}{additional arguments. These are ignored.}
}
\value{
A list comprising at most four elements.
        \item{dfbeta.units}{a vector containing DFBETAs for the units specified via argument \code{units}.}
        \item{dfbeta.coders}{a vector containing DFBETAs for the coders specified via argument \code{coders}.}
        \item{fits.units}{a list containing fit objects for the omitted units specified via argument \code{units}.}
        \item{fits.coders}{a list containing fit objects for the omitted coders specified via argument \code{coders}.}
}
\description{
Compute DFBETAs for units and/or coders.
}
\details{
This function computes DFBETAs for one or more units and/or one or more coders.
}
\examples{

# Analyze nominal data previously considered by Krippendorff.
# Assume a one-way design. Compute a DFBETA for unit 6, which
# should be rather influential.

kripp = matrix(c(1,2,3,3,2,1,4,1,2,NA,NA,NA,
                 1,2,3,3,2,2,4,1,2,5,NA,3,
                 NA,3,3,3,2,3,4,2,2,5,1,NA,
                 1,2,3,3,2,4,4,1,2,5,1,NA), 12, 4)
kripp

set.seed(12)
fit = gower.agree(kripp)
summary(fit)
inf = influence(fit, units = 6)

# Report the DFBETA for unit 6 and the estimate of mu when unit 6
# is ommitted.

inf$dfbeta.units
fit$mu.hat - inf$dfbeta.units
}
