% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tv-delay.R
\name{Profile.LS.TV.DDE}
\alias{Profile.LS.TV.DDE}
\title{Profile Estimation Functions for DDE with Time Varying Coefficients.}
\usage{
Profile.LS.TV.DDE(fn, data, times, pars, beta, kappa, coefs = NULL,
  basisvals = NULL, lambda, fd.obj = NULL, more = NULL, weights = NULL,
  quadrature = NULL, in.meth = "nlminb", out.meth = "nls",
  control.in = list(), control.out = list(), eps = 1e-06, active = NULL,
  posproc = FALSE, discrete = FALSE, poslik = FALSE, names = NULL,
  sparse = FALSE, basisvals0 = NULL, coefs0 = NULL, nbeta, ndelay, tau)
}
\arguments{
\item{fn}{fn A named list of functions giving the righthand side of a delay differential equation. The functions should have arguments
\describe{
\item{times}{he times at which the righthand side is being evaluated.}
\item{x}{The state values at those times.}
\item{p}{Parameters to be entered in the system.}
\item{more}{A list object containing additional inputs to \code{fn}, The distributed delay state are passed into derivative calculation as \code{more$y}.}
The list of functions should contain the elements:
\item{fn}{Function to calculate the right hand sid.}
\item{dfdx}{Function to calculate the derivative of each right-hand function with respect to the states.}
\item{dfdp}{calculates the derivative of therighthand side function with respect to parameters. }
\item{d2fdx2}{Function to calculate the second derivatives with respect to states.}
\item{d2fdxdp}{Function to calculate the cross derivatives of each right-hand function with respect to state and parameters.}
\item{dfdx.d}{Function to calculate the the derivative of each righthand function with respect to the delayed states.}
\item{d2fdx.ddp}{Function to calculate the cross derivatives of each righthand function with respect to the delayed states and parameters.}
\item{d2fdxdx.d}{Function to calculate the cross derivatives of each right-hand function with respect to the state and the delayed states.}
\item{d2fdx.d2}{Function to calculate the second derivatives of the right-hand function with respect to the delayed states.}
}}

\item{data}{Matrix of observed data values.}

\item{times}{Vector observation times for the data.}

\item{pars}{Initial values of parameters to be estimated processes.}

\item{beta}{Initial values of the contribution of lags for the delay.}

\item{kappa}{Initial values of parameters for a time varying function.}

\item{coefs}{Vector giving the current estimate of the coefficients in the spline.}

\item{basisvals}{Values of the collocation basis to be used. This should be a basis object from the fda package.}

\item{lambda}{Penalty value trading off fidelity to data with fidelity to dif- ferential equations.}

\item{fd.obj}{A functional data object; if this is non-null, coefs and basisvals is extracted from here.}

\item{more}{An object specifying additional arguments to fn.}

\item{weights}{Weights for weighted estimation.}

\item{quadrature}{Quadrature points, should contain two elements (if not \code{NULL})
\describe{
\item{qpts}{ sQuadrature points; defaults to midpoints between knots}
\item{qwts}{Quadrature weights; defaults to normalizing by the length of qpts.}
}}

\item{in.meth}{Inner optimization function currently one of \code{'nlminb'}, \code{'optim'}, or \code{'trustOptim'}.}

\item{out.meth}{Outer optimization function to be used, depending on the type of method.
\describe{
\item{nls}{Nonlinear least square}
\item{nnls.eq}{Nonlinear least square with equality or/and inequality constraints of the parameters.}
}}

\item{control.in}{Control object for inner optimization function.}

\item{control.out}{Control object for outer optimization function.}

\item{eps}{Finite differencing step size, if needed.}

\item{active}{Incides indicating which parameters of pars should be estimated; defaults to all of them.}

\item{posproc}{Should the state vector be constrained to be positive? If this is the case, the state is represented by an exponentiated basis expansion in the proc object.}

\item{discrete}{Is it a discrete process.}

\item{poslik}{Should the state be exponentiated before being compared to the data? When the state is represented on the log scale (posproc=TRUE), this is an alternative to taking the log of the data.}

\item{names}{The names of the state variables if not given by the column names of coefs.}

\item{sparse}{Should sparse matrices be used for basis values? This option can save memory when using 'trust' optimization method.}

\item{basisvals0}{Values of the collocation basis to be used for the history part of the data. This should be a basis object from the fda package.}

\item{coefs0}{Vector giving the  estimate of the coefficients in the spline for the history part of the data.}

\item{nbeta}{The number of lags for the delay.}

\item{ndelay}{A vector inidicating which state process has a delay term.}

\item{tau}{A list of delay lags.}
}
\value{
A list with elements
\describe{
\item{data}{The matrix for the observed data.}
\item{res}{The inner optimization result.}
\item{ncoefs}{The estimated coefficients.}
\item{lik}{The \code{lik} object generated.}
\item{proc}{The \code{proc} object generated.}
\item{pars}{The estimated parameters.}
\item{beta}{The estimated contribution of lags for the delay.}
\item{kappa}{The estimated parameters for the time varying function.}
\item{times}{The times at which the data are observed.}
\item{fdobj.d}{The functional data object for the estimated state process.}
\item{fdobj0}{The functional data object for the estimated state process of the history part.}
\item{tau}{The lags of delays.}
}
}
\description{
This function runs generalized profiling for DDE models with time varying coefficients.
This function carry out the profiled optimization method for DDe models using a sum of squared errors criteria for both fit to data and the fit of the derivatives to a delay differential equation with time varying coefficients.
}
\author{
Ziqian Zhou
}

