% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpb.Dataset.R
\name{gpb.Dataset}
\alias{gpb.Dataset}
\title{Construct \code{gpb.Dataset} object}
\usage{
gpb.Dataset(data, params = list(), reference = NULL, colnames = NULL,
  categorical_feature = NULL, free_raw_data = FALSE, info = list(), ...)
}
\arguments{
\item{data}{a \code{matrix} object, a \code{dgCMatrix} object or a character representing a filename}

\item{params}{a list of parameters}

\item{reference}{reference dataset}

\item{colnames}{names of columns}

\item{categorical_feature}{categorical features}

\item{free_raw_data}{TRUE for need to free raw data after construct}

\item{info}{a list of information of the \code{gpb.Dataset} object}

\item{...}{other information to pass to \code{info} or parameters pass to \code{params}}
}
\value{
constructed dataset
}
\description{
Construct \code{gpb.Dataset} object from dense matrix, sparse matrix
             or local file (that was created previously by saving an \code{gpb.Dataset}).
}
\examples{
\donttest{
data(agaricus.train, package = "gpboost")
train <- agaricus.train
dtrain <- gpb.Dataset(train$data, label = train$label)
data_file <- tempfile(fileext = ".data")
gpb.Dataset.save(dtrain, data_file)
dtrain <- gpb.Dataset(data_file)
gpb.Dataset.construct(dtrain)
}
}
