% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPModel.R
\name{saveGPModel}
\alias{saveGPModel}
\title{Save a \code{GPModel}}
\usage{
saveGPModel(gp_model, filename)
}
\arguments{
\item{gp_model}{a \code{GPModel}}

\item{filename}{filename for saving}
}
\value{
A \code{GPModel}
}
\description{
Save a \code{GPModel}
}
\examples{
\donttest{
data(GPBoost_data, package = "gpboost")

gp_model <- fitGPModel(group_data = group_data[,1], y = y, likelihood="gaussian")
pred <- predict(gp_model, group_data_pred = group_data_test[,1], predict_var = TRUE)
# Save model to file
filename <- tempfile(fileext = ".json")
saveGPModel(gp_model,filename = filename)
# Load from file and make predictions again
gp_model_loaded <- loadGPModel(filename = filename)
pred_loaded <- predict(gp_model_loaded, group_data_pred = group_data_test[,1], predict_var = TRUE)
# Check equality
pred$mu - pred_loaded$mu
pred$var - pred_loaded$var
}
}
\author{
Fabio Sigrist
}
