% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit.GPPM}
\alias{fit.GPPM}
\title{Fit a Gaussian process panel model}
\usage{
\method{fit}{GPPM}(gpModel, init = "random", useOptimizer = TRUE,
  verbose = FALSE, hessian = TRUE, ...)
}
\arguments{
\item{gpModel}{object of class GPPM. The Gaussian process panel model to be fitted.}

\item{init}{string or named numeric vector. Used to specify the starting values for the parameters. Can either be the string 'random' (default) or a numeric vector startVal of starting values. Which value belongs to which parameter is determined by the names attribute of startVal. See also the example.}

\item{useOptimizer}{boolean. Should the optimizer be used or not? For false the (possibly random) starting values are returned as the maximum likelihood estimates.}

\item{verbose}{boolean. Print diagnostic output?}

\item{hessian}{boolean. Compute the hessian at the maximum likelihood estimate?}

\item{...}{additional arguments (currently not used).}
}
\value{
A fitted Gaussian process panel model, which is an object of class 'GPPM'.
}
\description{
This function is used to fit a Gaussian process panel model,
which has been specified fit using \code{\link{gppm}}.
}
\examples{
\donttest{
#regular usage
data("demoLGCM")
lgcm <- gppm('muI+muS*t','varI+covIS*(t+t#)+varS*t*t#+(t==t#)*sigma',
        demoLGCM,'ID','y')
lgcmFit <- fit(lgcm)

#starting values as ML results
startVals <- c(10,1,10,3,10,1)
names(startVals) <- pars(lgcm)
lgcmFakeFit <- fit(lgcm,init=startVals,useOptimizer=FALSE)
stopifnot(identical(startVals,coef(lgcmFakeFit)))
}
}
