% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate.GPPM}
\alias{simulate.GPPM}
\title{Simulate from a Gaussian process panel model}
\usage{
\method{simulate}{GPPM}(object, nsim = 1, seed = NULL,
  parameterValues = NULL, verbose = FALSE, ...)
}
\arguments{
\item{object}{object of class GPPM. The Gaussian process panel model from which to simulate.}

\item{nsim}{integer. Number of data sets to generate.}

\item{seed}{numeric. Random seed to be used.}

\item{parameterValues}{numeric vector. Used to specify the values for the parameters.  Which value belongs to which parameter is determined by the names attribute of parameterValues. See also the example.}

\item{verbose}{boolean. Print diagnostic output?}

\item{...}{additional parameters (currently not used).}
}
\value{
A simulated data set, which is an object of class 'LongData'. If \code{nsim>1} a list of \code{nsim} simulated data sets.
}
\description{
This function is used to simulate from a Gaussian process panel model,
which has been specified using \code{\link{gppm}}.
}
\examples{
\donttest{
data("demoLGCM")
lgcm <- gppm('muI+muS*t','varI+covIS*(t+t#)+varS*t*t#+(t==t#)*sigma',
        demoLGCM,'ID','x')

parameterValues <- c(10,-1,0,10,0,0.1)
names(parameterValues) <-c('muI','muS','varI','varS','covIS','sigma')
simData <- simulate(lgcm,parameterValues=parameterValues)
}
}
