% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigen.R
\docType{methods}
\name{eigen,gpuMatrix-method}
\alias{eigen,gpuMatrix-method}
\alias{eigen,vclMatrix}
\alias{eigen,vclMatrix-method}
\title{gpuMatrix Eigen Decomposition}
\usage{
\S4method{eigen}{gpuMatrix}(x, symmetric, only.values = FALSE,
  EISPACK = FALSE)

\S4method{eigen}{vclMatrix}(x, symmetric, only.values = FALSE,
  EISPACK = FALSE)
}
\arguments{
\item{x}{A gpuMatrix object}

\item{symmetric}{logical indication if matrix is assumed to be symmetric.
If not specified or FALSE, the matrix is inspected for symmetry}

\item{only.values}{if TRUE, returns only eigenvalues (internals still
currently calculate both regardless)}

\item{EISPACK}{logical. Defunct and ignored}
}
\value{
\item{values}{A \code{gpuVector} containing the unsorted eigenvalues 
of x.}

\item{vectors}{A \code{gpuMatrix} containing the unsorted 
eigenvectors of x}
}
\description{
Computes the eigenvalues and eigenvectors for gpuMatrix objects.
}
\details{
This function currently implements the \code{qr_method} function
from the ViennaCL library.  As such, non-symmetric matrices are not 
supported given that OpenCL does not have a 'complex' data type.

Neither the eigenvalues nor the eigenvectors are sorted as done in the
base R eigen method.
}
\note{
The sign's may be different on some of the eigenvector elements.
As noted in the base eigen documentation:

Recall that the eigenvectors are only defined up to a
constant: even when the length is specified they are still
only defined up to a scalar of modulus one (the sign for real
matrices).

Therefore, although the signs may be different, the results are
functionally equivalent
}

