% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str.R
\name{str}
\alias{str}
\title{Predicting short tandem repeats}
\usage{
str(x, xformat = "default")
}
\arguments{
\item{x}{Nucleotide sequence(s) in raw format or a fasta file or a GenBank accession number(s); from which short tandem repeats will be predicted.
If the fasta file name does not contain an absolute path, the file name is relative to the current working directory.}

\item{xformat}{a character string specifying the format of x : default (raw), fasta, GenBank (GenBank accession number(s)).}
}
\value{
A dataframe of short tandem repeats' position, sequence and length. If more than one DNA sequence is provided as argument, an input ID is returned for repeats predicted from each input sequence.
}
\description{
This function predicts short tandem repeats
in 'x' in nucleotides. Nucleotide sequence can be provided in raw or fasta format or as GenBank accession number(s).
Internet is needed to connect to GenBank database, if accession number(s) is given as argument.
}
\details{
This function predicts short tandem repeats in nucleotide sequences and provide the position, sequence and length of the predicted repeats, if any.
}
\examples{
 ## Predicting short tandem repeats from raw nucleotide sequences
E1 <- c("TCTACACACACACACACACACGAAT", "tagggugugugugugugugugugutcct")
str(E1)

## Predicting short tandem repeats from nucleotide sequences in fasta file
## Not run: str(x="Example.fasta", xformat = "fasta")

## Predicting short tandem repeats from nucleotide sequences,
## using GenBank accession numbers.
## Internet connectivity is needed for this to work.
## Not run: str(c("BH114913", "AY611035"), xformat = "GenBank")
}
\references{
paper under review
}
\author{
Hannah O. Ajoge
}
