% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradDescentR.Methods.R
\name{SVRG}
\alias{SVRG}
\title{Stochastic Variance Reduce Gradient (SVRG) Method Learning Function}
\usage{
SVRG(dataTrain, alpha = 0.1, maxIter = 10, innerIter = 10, option = 2,
  seed = NULL)
}
\arguments{
\item{dataTrain}{a data.frame that representing training data (\eqn{m \times n}),
where \eqn{m} is the number of instances and \eqn{n} is the number
of variables where the last column is the output variable. dataTrain
must have at least two columns and ten rows of data that contain
only numbers (integer or float).}

\item{alpha}{a float value representing learning rate. Default value is 0.1}

\item{maxIter}{the maximal number of iterations in outerloop.}

\item{innerIter}{the maximal number of iterations in innerloop.}

\item{option}{is an option to set the theta. option 1 set the theta with the last theta
in innerloop. option 2 set the theta with random theta from 1 to last innerloop.}

\item{seed}{a integer value for static random. Default value is NULL, which means
the function will not do static random.}
}
\value{
a vector matrix of theta (coefficient) for linear model.
}
\description{
A function to build prediction model using SVRG method.
}
\details{
This function based on \code{\link{SGD}} with an optimization that accelerates
the process toward converging by reducing the gradient in \code{\link{SGD}}
}
\examples{
##################################
## Learning and Build Model with SVRG
## load R Package data
data(gradDescentRData)
## get z-factor data
dataSet <- gradDescentRData$CompressilbilityFactor
## split dataset
splitedDataSet <- splitData(dataSet)
## build model with SVRG
SVRGmodel <- SVRG(splitedDataSet$dataTrain)
#show result
print(SVRGmodel)

}
\references{
Rie Johnson, Tong Zang
Accelerating Stochastic Gradient Descent using Predictive Variance Reduction,
Advances in Neural Information Processing Systems,
pp. 315-323 (2013)
}
\seealso{
\code{\link{SSGD}}, \code{\link{SARAH}}, \code{\link{SARAHPlus}}
}
