% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_scatterbox.R
\name{plot_scatterbox}
\alias{plot_scatterbox}
\title{Plot a scatter plot on a boxplot with two variables.}
\usage{
plot_scatterbox(
  data,
  xcol,
  ycol,
  symsize = 2.5,
  symthick = 1,
  jitter = 0.2,
  b_alpha = 1,
  s_alpha = 1,
  ColPal = c("okabe_ito", "all_grafify", "bright", "contrast", "dark", "fishy",
    "kelly", "light", "muted", "pale", "r4", "safe", "vibrant"),
  ColSeq = TRUE,
  ColRev = FALSE,
  SingleColour = "NULL",
  TextXAngle = 0,
  fontsize = 20,
  ...
)
}
\arguments{
\item{data}{a data table object, e.g. data.frame or tibble.}

\item{xcol}{name of the column to plot on X axis. This should be a categorical variable.}

\item{ycol}{name of the column to plot on quantitative Y axis. This should be a quantitative variable.}

\item{symsize}{size of symbols used by \code{geom_point}. Default set to 2.5, increase/decrease as needed.}

\item{symthick}{thickness of symbol border (\code{stroke} parameter of \code{geom_point}), default set to 1.}

\item{jitter}{extent of jitter (scatter) of symbols, default is 0 (i.e. aligned symbols). To reduce symbol overlap, try 0.1-0.3 or higher.}

\item{b_alpha}{fractional opacity of boxplot, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{s_alpha}{fractional opacity of symbols, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{ColPal}{grafify colour palette to apply, default "okabe_ito"; see \code{\link{graf_palettes}} for available palettes.}

\item{ColSeq}{logical TRUE or FALSE. Default TRUE for sequential colours from chosen palette. Set to FALSE for distant colours, which will be applied using  \code{scale_fill_grafify2}.}

\item{ColRev}{whether to reverse order of colour within the selected palette, default F (FALSE); can be set to T (TRUE).}

\item{SingleColour}{a colour hexcode (starting with #), a number between 1-154, or names of colours from \code{grafify} colour palettes to fill along X-axis aesthetic. Accepts any colour other than "black"; use \code{grey_lin11}, which is almost black.}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{theme_classic}, default set to size 20.}

\item{...}{any additional arguments to pass to \code{ggplot2}\link{geom_boxplot}.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function takes a data table, X and Y variables, and plots a graph with a scatter plot and box and whiskers using \code{\link[ggplot2]{geom_boxplot}} and \code{\link[ggplot2]{geom_point}} geometries. The boxplot shows IQR and whiskers depict 1.5*IQR.
Note that \code{\link{geom_boxplot}} option for outliers is set to \code{outlier.alpha = 0}.
The X variable is mapped to the \code{fill} aesthetic in both boxplot and symbols, and its colour can be changed using \code{ColPal} option.
Colours can be changed using \code{ColPal}, \code{ColRev} or \code{ColSeq} arguments. Colours available can be seen quickly with \code{\link{plot_grafify_palette}}.
\code{ColPal} can be one of the following: "okabe_ito", "dark", "light", "bright", "pale", "vibrant,  "muted" or "contrast".
\code{ColRev} (logical TRUE/FALSE) decides whether colours are chosen from first-to-last or last-to-first from within the chosen palette.
\code{ColSeq} (logical TRUE/FALSE) decides whether colours are picked by respecting the order in the palette or the most distant ones using \code{\link[grDevices]{colorRampPalette}}.
}
\details{
If there are many groups along the X axis and you prefer a single colour for the graph,use the \code{SingleColour} argument.

The size of symbols can be adjusted using \code{symsize} set to 1 by default.
Transparency of boxplot and symbols can be set independently with \code{b_alpha} and \code{s_alpha}, respectively.

Three types of plots are available for scatter/jitter symbols and either bars+SD, boxplot or violin plots: \code{\link{plot_scatterbar_sd}}, \code{\link{plot_scatterbox}} and \code{\link{plot_scatterviolin}}.
These are related to the three "dot" versions that use a different geometry for symbols: \code{\link{plot_scatterbox}}, \code{\link{plot_dotbar_sd}} and \code{\link{plot_dotviolin}}.
}
\examples{
plot_scatterbox(data = data_cholesterol, 
xcol = Treatment, ycol = Cholesterol)

plot_scatterbox(data = data_doubling_time, 
xcol = Student, ycol = Doubling_time,
SingleColour = "ok_grey")

}
