% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_functions.R
\name{prop}
\alias{prop}
\alias{prop.winmove}
\alias{prop.numeric}
\title{Calculate proportion of a given value}
\usage{
prop(x, lc_class, ...)

\method{prop}{winmove}(x, lc_class, d, type, ...)

\method{prop}{numeric}(x, lc_class, ...)
}
\arguments{
\item{x}{numeric, winmove. The data over which to calculate the proportion}

\item{lc_class}{numeric. The class value to calculate the proportion of}

\item{...}{further arguments passed to or from other methods}

\item{d}{numeric. If \code{type=circle}, the radius of the circle (in units of the
CRS). If \code{type=rectangle} the dimension of the rectangle (one or two numbers)}

\item{type}{character. The shape of the moving window}
}
\value{
If \code{class(x) == "winmove"}, a smoothed raster with the proportion of
  cells of the given class calculated within the specified moving window

  If \code{class(x) == "numeric"}, a single value representing the proportion of values
  of a given class in \code{x}
}
\description{
Calculate the proportion of a given value present within a raster. Useful for
calculating land-cover or soil type proportions. Should be used with a categorical
raster
}
\examples{

# load required data
data(cat_ls)

# convert data to object of class winmove
cat_ls <- new("winmove", cat_ls)

# aggregate using a rectangular window with dimension 5 for class 3
d <- prop(cat_ls, d = 5, type = "rectangle", lc_class = 3)

# convert data to object of class numeric
cat_ls <- raster::values(cat_ls)
d <- prop(cat_ls, lc_class = 2)
}
\keyword{focal}
\keyword{mean}
\keyword{spatial}
