% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_grainscape.R
\name{theme_grainscape}
\alias{theme_grainscape}
\title{A \code{ggplot2} theme for \code{grainscape}}
\usage{
theme_grainscape(base_size = 9, base_family = "")
}
\arguments{
\item{base_size}{Base font size}

\item{base_family}{Base font family}
}
\value{
A theme suitable for use with \code{\link[=ggplot]{ggplot()}}
}
\description{
A \code{\link[=ggplot2]{ggplot2()}} theme designed for \code{grainscape} based on the
\code{\link[ggthemes:theme_map]{ggthemes::theme_map()}} theme, with several modifications.
}
\examples{
## Load raster landscape
tiny <- raster::raster(system.file("extdata/tiny.asc", package = "grainscape"))

## Create a resistance surface from a raster using an is-becomes reclassification
tinyCost <- raster::reclassify(tiny, rcl = cbind(c(1, 2, 3, 4), c(1, 5, 10, 12)))
## Produce a patch-based MPG where patches are resistance features=1
tinyPatchMPG <- MPG(cost = tinyCost, patch = tinyCost == 1)
if (interactive()) {
  library(ggplot2)

  ## Plot the patches in a minimum planar graph
  theme_set(theme_grainscape())
  plot(tinyPatchMPG, quick = "mpgPlot")
}
}
\seealso{
\code{\link[=ggGS]{ggGS()}}, \code{\link[=plot]{plot()}}, \code{\link[ggthemes:theme_map]{ggthemes::theme_map()}}
}
\author{
Paul Galpern and Alex Chubaty
}
