% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grandR.R
\name{Coldata}
\alias{Coldata}
\alias{Coldata<-}
\title{Get the column annotation table or add additional columns to it}
\usage{
Coldata(data, column = NULL, value = NULL)

Coldata(data, column) <- value
}
\arguments{
\item{data}{A grandR object}

\item{column}{The name of the additional annotation column; can also be a data frame (then value is ignored and the data frame is added)}

\item{value}{The additional annotation per sample or cell}
}
\value{
Either the column annotation table or a new grandR object having an updated column annotation table
}
\description{
The columns of a grandR object are samples or cells.
The column annotation table contains meta information for the columns of a grandR object.
When loaded from the GRAND-SLAM output, this this constructed from the sample/cell names by
\code{\link{MakeColdata}}
}
\details{
A new column can be added either by \code{data<-Coldata(data,name,values)} or by \code{Coldata(data,name)<-values}.

Several new columns can be added by \code{data<-Coldata(data,df)} where df is either a data frame or matrix.

The column named \emph{Condition} has a special meaning in this table: It is used by several functions to stratify the columns
during the analysis (e.g. to estimate separate kinetic parameters with \code{\link{FitKinetics}} or it is used as covariate for
\code{\link{LFC}} or \code{\link{LikelihoodRatioTest}}). For that reason there are special functions to set and get this column.
}
\examples{
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=c("Cell",Design$dur.4sU,Design$Replicate))

head(GeneInfo(sars))
GeneInfo(sars,"LengthCategory")<-cut(GeneInfo(sars)$Length,c(0,1500,2500,Inf),
                                          labels=c("Short","Medium","Long"))
table(GeneInfo(sars)$LengthCategory)

}
\seealso{
\link{GeneInfo}, \link{MakeColdata}, \link{Condition}
}
\concept{grandr}
