% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{FitKineticsSnapshot}
\alias{FitKineticsSnapshot}
\title{Fits RNA kinetics from snapshot experiments}
\usage{
FitKineticsSnapshot(
  data,
  name.prefix = "Kinetics",
  reference.columns,
  slot = DefaultSlot(data),
  conditions = NULL,
  time.labeling = Design$dur.4sU,
  time.experiment = NULL,
  sample.f0.in.ss = TRUE,
  N = 10000,
  N.max = N * 10,
  CI.size = 0.95,
  seed = 1337,
  dispersion = NULL,
  hierarchical = TRUE,
  correct.labeling = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{the grandR object}

\item{name.prefix}{the prefix for the new analysis name; a dot and the column names of the contrast matrix are appended; can be NULL (then only the contrast matrix names are used)}

\item{reference.columns}{a reference matrix usually generated by \link{FindReferences} to define reference samples for each sample (see details)}

\item{slot}{the data slot to take f0 and totals from}

\item{conditions}{character vector of all condition names to estimate kinetics for; can be NULL (i.e. all conditions)}

\item{time.labeling}{the column in the column annotation table denoting the labeling duration or the labeling duration itself}

\item{time.experiment}{the column in the column annotation table denoting the experimental time point (can be NULL, see details)}

\item{sample.f0.in.ss}{whether or not to sample f0 under steady state conditions}

\item{N}{the sample size}

\item{N.max}{the maximal number of samples (necessary if old RNA > f0); if more are necessary, a warning is generated}

\item{CI.size}{A number between 0 and 1 representing the size of the credible interval}

\item{seed}{Seed for the random number generator}

\item{dispersion}{overdispersion parameter for each gene; if NULL this is estimated from data}

\item{hierarchical}{Take the NTR from the hierarchical Bayesian model (see details)}

\item{correct.labeling}{Labeling times have to be unique; usually execution is aborted, if this is not the case; if this is set to true, the median labeling time is assumed}

\item{verbose}{Vebose output}
}
\value{
a new grandR object including new analysis tables (one per condition). The columns of the new analysis table are
\itemize{
 \item{"s"}{the posterior mean synthesis rate}
 \item{"HL"}{the posterior mean RNA half-life}
 \item{"s.cred.lower"}{the lower CI boundary of the synthesis rate}
 \item{"s.cred.upper"}{the upper CI boundary of the synthesis rate}
 \item{"HL.cred.lower"}{the lower CI boundary of the half-life}
 \item{"HL.cred.upper"}{the upper CI boundary of the half-life}
}
}
\description{
Compute the posterior distributions of RNA synthesis and degradation from snapshot experiments for each condition
}
\details{
The kinetic parameters s and d are computed using \link{TransformSnapshot}. For that, the sample either must be in steady state
(this is the case if defined in the reference.columns matrix), or if the levels at an earlier time point are known from separate samples,
so called temporal reference samples. Thus, if s and d are estimated for a set of samples x_1,...,x_k (that must be from the same time point t),
we need to find (i) the corresponding temporal reference samples from time t0, and (ii) the time difference between t and t0.

The temporal reference samples are identified by the reference.columns matrix. This is a square matrix of logicals, rows and columns correspond to all samples
and TRUE indicates that the row sample is a temporal reference of the columns sample. This time point is defined by \code{time.experiment}. If \code{time.experiment}
is NULL, then the labeling time of the A or B samples is used (e.g. useful if labeling was started concomitantly with the perturbation, and the steady state samples
are unperturbed samples).

By default, the hierarchical Bayesian model is estimated. If hierarchical = FALSE, the NTRs are sampled from a beta distribution
that approximates the mixture of betas from the replicate samples.

if N is set to 0, then no sampling from the posterior is performed, but the transformed MAP estimates are returned
}
\concept{snapshot}
