% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{PlotPCA}
\alias{PlotPCA}
\title{Make a PCA plot}
\usage{
PlotPCA(
  data,
  mode.slot = DefaultSlot(data),
  ntop = 500,
  aest = NULL,
  x = 1,
  y = 2,
  columns = NULL
)
}
\arguments{
\item{data}{the grandR object that contains the data to plot}

\item{mode.slot}{the mode and slot of data to plot; slot in the grandr object (eg "count")}

\item{ntop}{how many genes to use}

\item{aest}{parameter to set the visual attributes}

\item{x}{number of principal component to show on the x axis (numeric)}

\item{y}{number of principal component to show on the y axis (numeric)}

\item{columns}{which columns (i.e. samples or cells) to perform PCA on (see details)}
}
\value{
a PCA plot
}
\description{
Make a PCA plot
}
\details{
Columns can be given as a logical, integer or character vector representing a selection of the columns (samples or cells).
The expression is evaluated in an environment having the \code{\link{Coldata}}, i.e. you can use names of \code{\link{Coldata}} as variables to
conveniently build a logical vector (e.g., columns=Condition=="x").
}
\concept{globalplot}
