% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grandR.R
\name{UpdateSymbols}
\alias{UpdateSymbols}
\title{Update symbols using biomaRt}
\usage{
UpdateSymbols(data, species = NULL, current.value = "ensembl_gene_id")
}
\arguments{
\item{data}{a grandR object}

\item{species}{the species the genes belong to (eg "Homo sapiens"); can be NULL, then the species is inferred from gene ids (see details)}

\item{current.value}{What it the current value in the symbols field?}
}
\value{
a grandR object with updated symbol names
}
\description{
If your input files only contained ENSEMBL ids, use this to add gene symbols!
}
\details{
If no species is given, a very simple automatic inference is done, which will only work when having human or mouse ENSEMBL identifiers as gene ids.
If you need to specify species, it must be one of \code{biomaRt::listDatasets(biomaRt::useMart("ensembl"))$dataset}!

Current.value must be one of \code{biomaRt::listAttributes(biomaRt::useMart("ensembl"))$name}!
}
\concept{grandr}
