% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grandR.R
\name{GetTable}
\alias{GetTable}
\title{Obtain a genes x values table}
\usage{
GetTable(
  data,
  type = DefaultSlot(data),
  columns = NULL,
  genes = Genes(data),
  ntr.na = TRUE,
  gene.info = FALSE,
  summarize = NULL,
  prefix = NULL,
  name.by = "Symbol"
)
}
\arguments{
\item{data}{A grandR object}

\item{type}{Either a mode.slot (see details) or a regex to be matched against analysis names. Can also be a vector}

\item{columns}{A vector of columns (either condition/cell names if the type is a mode.slot, or names in the output table from an analysis; use \link{Columns}(data,<analysis>) to learn which columns are available); all condition/cell names if NULL}

\item{genes}{Restrict the output table to the given genes}

\item{ntr.na}{For columns representing a 4sU naive sample, should types \emph{ntr},\emph{new.count} and \emph{old.count} be 0,0 and count (ntr.na=FALSE; can be any other slot than count) or NA,NA and NA (ntr.na=TRUE)}

\item{gene.info}{Should the table contain the \link{GeneInfo} values as well (at the beginning)?}

\item{summarize}{Should replicates by summarized? see details}

\item{prefix}{Prepend each column in the output table (except for the gene.info columns) by the given prefix}

\item{name.by}{A column name of \link{Coldata}(data). This is used as the rownames of the output table}
}
\value{
A data frame containing the desired values
}
\description{
This is the main function to access slot data for all genes as a large matrix. If data from a particular gene (or a small set of genes)
must be retrieved, use the \code{\link{GetData}} function. For analysis results, use the \code{\link{GetAnalysisTable}} function.
}
\details{
This is a convenience wrapper for \link{GetData} (values from data slots) and \link{GetAnalysisTable} (values from analyses).
Types can refer to any of the two (and can be mixed). If there are types from both data and analyses, columns must be NULL.
Otherwise columns must either be condition/cell names (if type refers to one or several data slots), or regular expressions
to match against the names in the analysis tables.

Columns definitions for data slots can be given as a logical, integer or character vector representing a selection of the columns (samples or cells).
The expression is evaluated in an environment having the \code{\link{Coldata}}, i.e. you can use names of \code{\link{Coldata}} as variables to
conveniently build a logical vector (e.g., columns=Condition=="x").

To refer to data slots via \code{type}, the mode.slot syntax can be used: Each name is either a data slot, or one of (new,old,total)
followed by a dot followed by a slot. For new or old, the data slot value is multiplied by ntr or 1-ntr. This can be used e.g. to obtain the \emph{new counts}.

The summarization parameter can only be specified if columns is NULL. It is either a summarization matrix (\link{GetSummarizeMatrix}) or
TRUE (in which case \link{GetSummarizeMatrix}(data) is called). If there a NA values, they are imputed as the mean per group!
}
\examples{
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=c("Condition",Design$dur.4sU,Design$Replicate))
sars <- Normalize(FilterGenes(sars))

head(GetTable(sars))
# DefaultSlot values, i.e. size factor normalized read counts for all samples
head(GetTable(sars,summarize=TRUE))
# DefaultSlot values averaged over the two conditions
head(GetTable(sars,type="new.count",columns=!no4sU))
# Estimated counts for new RNA for all samples with 4sU

sars<-LFC(sars,contrasts=GetContrasts(sars,group = "duration.4sU"))
head(GetAnalysisTable(sars,columns="LFC"))
# Estimated fold changes SARS vs Mock for each time point



}
\seealso{
\link{GetData},\link{GetAnalysisTable},\link{DefaultSlot},\link{Genes},\link{GetSummarizeMatrix}
}
\concept{data}
