% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropout.R
\name{correctdropout}
\alias{correctdropout}
\alias{Correct4sUDropoutHLFactor}
\alias{Correct4sUDropoutHLSpline}
\title{Correct for 4sU dropout}
\usage{
Correct4sUDropoutHLFactor(
  data,
  pairs = Findno4sUPairs(data),
  factors = Estimate4sUDropoutPercentage(data, pairs = pairs, ...),
  ...
)

Correct4sUDropoutHLSpline(data, pairs = Findno4sUPairs(data), spline.df = 15)
}
\arguments{
\item{data}{a grandR object}

\item{pairs}{a no4sU pairs list as generated by \link{Findno4sUPairs}}

\item{factors}{the 4sU dropout percentages}

\item{...}{further arguments to be passed to or from other methods.}

\item{spline.df}{the degrees of freedom to be used for smoothing splines}
}
\value{
a new grandR object that is corrected for 4sU dropout
}
\description{
For several potential reasons, a sample specific percentage of reads from labelled RNA might be lost.
This can be corrected for by increasing the amount of labelled RNA (see details).
}
\details{
The factor based correction approach requires estimates of the 4sU dropout percentage d. Labelled RNA is multiplied by 1/(1-d),
and total count and NTRs are adapted accordingly. alpha and beta are also adapted such that their sum is maintained, but the mean of the
corresponding beta function is the new NTR. All other slots are treated to be expression estimates (and are adapted accordingly).

The spline approach uses quantile regression to fit a smoothing spline to the 4sU dropout rank plot, which is then used to correct labelled RNA.
}
\seealso{
\link{Estimate4sUDropoutPercentage},\link{ComputeSummaryStatistics}
}
\concept{dropout}
