% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropout.R
\name{dropoutpercent}
\alias{dropoutpercent}
\alias{Estimate4sUDropoutPercentage}
\alias{Estimate4sUDropoutPercentageForSample}
\title{Estimate 4sU dropout percentages}
\usage{
Estimate4sUDropoutPercentage(data, pairs = Findno4sUPairs(data), ...)

Estimate4sUDropoutPercentageForSample(
  data,
  w4sU,
  no4sU,
  ntr = w4sU,
  LFC.fun = lfc::PsiLFC,
  type = c("spearman", "quantreg", "linear", "lowess"),
  bootstrap = FALSE
)
}
\arguments{
\item{data}{a grandR object}

\item{pairs}{a no4sU pairs list as generated by \link{Findno4sUPairs}}

\item{...}{further arguments to be passed to or from other methods.}

\item{w4sU}{the name of a 4sU sample}

\item{no4sU}{the name(s) of equivalent no4sU sample(s)}

\item{ntr}{the name of a sample to take NTRs from (usually equal to w4sU)}

\item{LFC.fun}{function to compute log fold change (default: \link[lfc]{PsiLFC}, other viable option: \link[lfc]{NormLFC})}

\item{type}{one of "spearman","quantreg","linear" or "lowess" (see details)}

\item{bootstrap}{if TRUE, perform a single bootstrap sample  (by drawing genes with replacement)}
}
\value{
the percentage of 4sU dropout for a single sample (Estimate4sUDropoutPercentageForSample) or all samples (Estimate4sUDropoutPercentage)
}
\description{
For several potential reasons, a sample specific percentage of reads from labelled RNA might be lost.
This percentage can be estimated from data of this sample and an equivalent 4sU naive control (see details).
}
\details{
The percentage of 4sU dropout is estimated by numerical optimization of the factor f
that has to be multiplied with the NTR to mitigate the effect of 4sU dropout. The exact objective function depends on the type parameter:
\itemize{
  \item{spearman: f is estimated such that the spearman correlation coefficient of the log2 fold change 4sU/no4sU vs the ntr rank is 0}
  \item{quantreg: f is estimated such that the slope of a median regression with the the ntr rank as independent variable and the log2 fold change 4sU/no4sU as dependent variable is 0}
  \item{linear: f is estimated such that the slope of a linear regression with the the ntr rank as independent variable and the log2 fold change 4sU/no4sU as dependent variable is 0}
  \item{lowess: f is estimated by minimizing the sum-of-squares of the residuals from a lowess regression with the the ntr rank as independent variable and the log2 fold change 4sU/no4sU as dependent variable is 0}
}
Once f is computed the percentage of 4sU dropout is f/(f+1).
}
\seealso{
\link{Correct4sUDropoutHLFactor},\link{ComputeSummaryStatistics}
}
\concept{dropout}
