% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readsimulator.R
\name{SimulateTimeCourse}
\alias{SimulateTimeCourse}
\title{Simulate a complete time course of metabolic labeling - nucleotide conversion RNA-seq data.}
\usage{
SimulateTimeCourse(
  condition,
  gene.info,
  s,
  d,
  f0 = s/d,
  s.variation = 1,
  d.variation = 1,
  dispersion,
  num.reads = 1e+07,
  timepoints = c(0, 0, 0, 1, 1, 1, 2, 2, 2, 4, 4, 4),
  beta.approx = FALSE,
  conversion.reads = FALSE,
  verbose = TRUE,
  seed = NULL,
  ...
)
}
\arguments{
\item{condition}{A user-defined condition name (which is placed into the \code{\link{Coldata}} of the final grandR object)}

\item{gene.info}{either a data frame containing gene annotation or a vector of gene names}

\item{s}{a vector of synthesis rates}

\item{d}{a vector of degradation rates (to get a specific half-life HL, use d=log(2)/HL)}

\item{f0}{the abundance at time t=0}

\item{s.variation}{biological variability of s among all samples (see details)}

\item{d.variation}{biological variability of d among all samples (see details)}

\item{dispersion}{a vector of dispersion parameters (estimate from data using DESeq2, e.g. by the estimate.dispersion utility function)}

\item{num.reads}{a vector representing the number of reads for each sample}

\item{timepoints}{a vector representing the labeling duration (in h) for each sample}

\item{beta.approx}{should the beta approximation of the NTR posterior be computed?}

\item{conversion.reads}{also output the number of reads with conversion}

\item{verbose}{Print status updates}

\item{seed}{seed value for the random number generator (set to make it deterministic!)}

\item{...}{provided to \code{\link{SimulateReadsForSample}}}
}
\value{
a grandR object containing the simulated data in its data slots and the true parameters in the gene annotation table
}
\description{
This function takes a vector of \emph{true} synthesis rates and RNA half-lives, and then simulates
data for multiple time points and replicates. Both synthesis rate and RNA half-lives are assumed to be constant,
but the system might not be in steady-state.
}
\details{
If \emph{s.variation} or \emph{d.variation} are > 1, then for each gene a random gaussian is added to s (or d)
such that 90% of all s (or d) are \emph{s.variation}-fold away from s (below or above; i.e. s is multiplied with 2^rnorm(n,mean=0,sd=x), with x chosen such that the 95% quantile
of the gaussian is log2(s.variation).
}
\concept{simulation}
