% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_graph_modul.R
\name{compute_graph_modul}
\alias{compute_graph_modul}
\title{Compute modules from a graph by maximising modularity}
\usage{
compute_graph_modul(
  graph,
  algo = "fast_greedy",
  node_inter = NULL,
  nb_modul = NULL
)
}
\arguments{
\item{graph}{An object of class \code{igraph}. Its nodes must have names.}

\item{algo}{A character string indicating the algorithm used to create
the modules with \pkg{igraph}. \itemize{
\item{If \code{algo = 'fast_greedy'} (default),
function \code{cluster_fast_greedy} from \pkg{igraph}
is used (Clauset et al., 2004).}
\item{If \code{algo = 'walktrap'}, function \code{cluster_walktrap}
from \pkg{igraph} is used (Pons et Latapy, 2006) with 4 steps
(default options).}
\item{If \code{algo = 'louvain'}, function \code{cluster_louvain}
from \pkg{igraph} is used (Blondel et al., 2008). In that case, the number
of modules created in each graph is imposed.}
\item{If \code{algo = 'optimal'}, function \code{cluster_optimal}
from \pkg{igraph} is used (Brandes et al., 2008) (can be very long).
In that case, the number of modules created in each graph is imposed.}
}}

\item{node_inter}{(optional, default = NULL) A character string indicating
whether the links of the graph are weighted by distances or by similarity
indices. It is only used to compute the modularity index. It can be:
\itemize{
\item{'distance': Link weights correspond to distances. Nodes that are close
to each other will more likely be in the same module.}
\item{'similarity': Link weights correspond to similarity indices. Nodes that
are similar to each other will more likely be in the same module. Inverse
link weights are then used to compute the modularity index.}
}}

\item{nb_modul}{(optional , default = NULL) A numeric or integer value
indicating the number of modules in the graph. When this number is not
specified, the optimal value is retained.}
}
\value{
A \code{data.frame} with the node names and the corresponding
module ID.
}
\description{
The function computes  modules from a graph by maximising
modularity.
}
\examples{
data("data_tuto")
mat_gen <- data_tuto[[1]]
graph <- gen_graph_thr(mat_w = mat_gen, mat_thr = mat_gen,
                            thr = 0.8)
res_mod <- compute_graph_modul(graph = graph,
                                algo = "fast_greedy",
                                node_inter = "distance")
}
\author{
P. Savary
}
