% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter_dist_g.R
\name{scatter_dist_g}
\alias{scatter_dist_g}
\title{Plot scatterplots of distances to visualize the graph pruning intensity}
\usage{
scatter_dist_g(
  mat_y,
  mat_x,
  graph,
  thr_y = NULL,
  thr_x = NULL,
  pts_col_1 = "#999999",
  pts_col_2 = "black"
)
}
\arguments{
\item{mat_y}{A symmetric (complete) \code{matrix} or \code{dist} object with
pairwise (genetic or landscape) distances between populations or sample
sites. These values will be the point coordinates on the y axis.
\code{mat_y} is the matrix used to weight the links of the graph \code{x},
whose nodes correspond to row and column names of \code{mat_y}.}

\item{mat_x}{A symmetric (complete) \code{matrix} or \code{dist} object with
pairwise (genetic or landscape) distances between populations or sample
sites. These values will be the point coordinates on the x axis.
\code{mat_x} and \code{mat_y} must have the same row and column names,
ordered in the same way.}

\item{graph}{A graph object of class \code{igraph}.
Its nodes must have the same names as the row and column of
\code{mat_y} and \code{mat_x} matrices. \code{x} must have weighted links.
Link weights have to be values from \code{mat_y} matrix. \code{graph} must
be an undirected graph.}

\item{thr_y}{(optional) A numeric or integer value used to remove values
from the data before to plot. All values from \code{mat_y} above \code{thr_y}
are removed from the data.}

\item{thr_x}{(optional) A numeric or integer value used to remove values
from the data before to plot. All values from \code{mat_x} above \code{thr_x}
are removed from the data.}

\item{pts_col_1}{(optional) A character string indicating the color used to
plot the points associated to all populations or sample sites
pairs (default: "#999999"). It must be a hexadecimal color
code or a color used by default in R.}

\item{pts_col_2}{(optional) A character string indicating the color used to
plot the points associated to populations or sample sites pairs connected on
the graph (default: "black"). It must be a hexadecimal color
code or a color used by default in R.}
}
\value{
A ggplot2 object to plot
}
\description{
The function enables to plot scatterplots of the relationship
between two distances (often a genetic distance and a landscape distance
between populations or sample sites), while highlighting the population pairs
between which a link was conserved during the creation of a graph whose
nodes are populations (or sample sites). It thereby allows to visualize the
graph pruning intensity.
}
\details{
IDs in \code{mat_y} and \code{mat_x} must be the same and refer
to the same sampling sites or populations, and both matrices must be ordered
in the same way.
Matrices of genetic distance can be computed using
\code{\link{mat_gen_dist}}.
Matrices of landscape distance can be computed using
\code{\link{mat_geo_dist}} when the landscape distance needed is a
Euclidean geographical distance.
This function is based upon \code{\link{scatter_dist}} function.
}
\examples{
data(data_tuto)
mat_gen <- data_tuto[[1]]
mat_dist <- suppressWarnings(mat_geo_dist(data=pts_pop_simul,
      ID = "ID",
      x = "x",
      y = "y"))
mat_dist <- mat_dist[order(as.character(row.names(mat_dist))),
                     order(as.character(colnames(mat_dist)))]
x <- gen_graph_topo(mat_w = mat_gen, mat_topo = mat_dist, topo = "gabriel")
scat <- scatter_dist_g(mat_y = mat_gen, mat_x = mat_dist,
                       graph = x)
}
\author{
P. Savary
}
