% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generation.R
\name{rsbm}
\alias{rsbm}
\title{Simulate a network of a stochastic block model}
\usage{
rsbm(n, theta, directed = TRUE)
}
\arguments{
\item{n}{number of vertices}

\item{theta}{stochastic block model parameter with latent group probabilities $pi and
connectivy parameters $gamma}

\item{directed}{directed network (TRUE by default) or undirected (FALSE)}
}
\value{
list with simulated adjacency matrix ($adj) and node labels ($Z)
}
\description{
Simulate a network of a stochastic block model
}
\examples{
theta1 <- list(pi=c(.5,.5), gamma=matrix((1:4)/8,2,2))
rsbm(10, theta1)
}
