% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_evidence.R
\name{test_evidence}
\alias{test_evidence}
\title{Test Graphical Evidence}
\usage{
test_evidence(
  num_runs,
  prior_name = c("Wishart", "BGL", "GHS", "G_Wishart"),
  input_seed = NULL
)
}
\arguments{
\item{num_runs}{An integer number that specifies how many runs of 
graphical evidence will be executed on the test parameters, as multiple
runs allows us to quantify uncertainty on the estimator.}

\item{prior_name}{The name of the prior for being tested with preexisting
test parameters, this is one of 'Wishart', 'BGL', 'GHS', 'G_Wishart'}

\item{input_seed}{An integer value that will be used as a random seed to
make outputs repeatable.}
}
\value{
A list of results which contains the mean marginal likelihood, the
standard deviation of the estimator, and the raw results in a vector
}
\description{
Tests any of the allowed priors with preexisting test inputs which
should yield reproducible results, as the random seed is reset during
this function call
}
\examples{
# Compute the marginal 10 times with random column permutations of the 
# preexisting test parameters for G-Wishart prior 
test_evidence(num_runs=3, 'G_Wishart')
}
