% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation_emtp2.R
\name{emtp2}
\alias{emtp2}
\title{Performs Gaussian likelihood optimization under Laplacian matrix constraints.}
\usage{
emtp2(Gamma, tol = 1e-06, verbose = TRUE, initial_point = TRUE)
}
\arguments{
\item{Gamma}{conditionally negative semidefinite matrix. This will be typically the empirical variogram matrix.}

\item{tol}{The convergence tolerance. The algorithm terminates when the sum of absolute differences between two iterations is below \code{tol}.}

\item{verbose}{if TRUE (default) the output will be printed.}

\item{initial_point}{if TRUE (default), the algorithm will construct an initial point before the iteration steps.}
}
\value{
A list consisting of:
\item{\code{G_emtp2}}{The optimal value of the variogram matrix}
\item{\code{it}}{The number of iterations}
}
\description{
This function implements a block descent algorithm to find the maximum of the
Gaussian log-likelihood under the constraint that the concentration matrix is a Laplacian matrix.
See \insertCite{roe2021;textual}{graphicalExtremes} for details.
}
\references{
\insertAllCited{}
}
