% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_helpers.R
\name{simu_px_tree_HR}
\alias{simu_px_tree_HR}
\title{Simulate HR extremal functions on a tree}
\usage{
simu_px_tree_HR(n, Gamma_vec, A)
}
\arguments{
\item{n}{Number of simulations.}

\item{Gamma_vec}{Numeric vector with \code{d-1} elements, where \code{d} is the
number of nodes in the tree (and \code{d-1} is the number of edges).}

\item{A}{Numeric \dxd1 matrix; the rows represent the nodes
in the tree, the columns represent the edges. For a fixed node
\eqn{k = 1, \dots, d}{k = 1, ..., d}, each entry \eqn{(i, j)} is
equal to 1 if the edge in position \code{j} is on the directed path from node
\code{k} to node \code{i} in the polytree rooted at node \code{k}.}
}
\value{
Numeric \nxd matrix. Simulated data.
}
\description{
Simulates the Huessler--Reiss extremal functions on a tree
}
\keyword{internal}
