% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_examples.R
\name{generate_random_chordal_graph}
\alias{generate_random_chordal_graph}
\alias{generate_random_connected_graph}
\alias{generate_random_tree}
\alias{generate_random_cactus}
\title{Generate random graphs}
\usage{
generate_random_chordal_graph(
  d,
  cMin = 2,
  cMax = 6,
  sMin = 1,
  sMax = 4,
  block_graph = FALSE,
  ...
)

generate_random_connected_graph(
  d,
  m = NULL,
  p = 2/(d + 1),
  maxTries = 1000,
  ...
)

generate_random_tree(d)

generate_random_cactus(d, cMin = 2, cMax = 6)
}
\arguments{
\item{d}{Number of vertices in the graph}

\item{cMin}{Minimal size of cliques/blocks (last one might be smaller if necessary)}

\item{cMax}{Maximal size of cliques/blocks}

\item{sMin}{Minimal size of separators}

\item{sMax}{Maximal size of separators}

\item{block_graph}{Force \verb{sMin == sMax == 1} to produce a block graph}

\item{...}{Ignored, only allowed for compatibility}

\item{m}{Number of edges in the graph (specify this or \code{p})}

\item{p}{Probability of each edge being in the graph (specify this or \code{m})}

\item{maxTries}{Maximum number of tries to produce a connected Erdoes-Renyi graph}
}
\value{
An [\code{igraph::graph}] object
}
\description{
Generate random graphs with different structures.
These do not follow well-defined distributions and are mostly meant for quickly
generating test models.
}
\details{
\code{generate_random_chordal_graph} generates a random chordal graph by starting with a (small) complete graph
and then adding new cliques until the specified size is reached.
The sizes of cliques and separators can be specified.

\code{generate_random_connected_graph} first tries to generate an Erdoes-Renyi graph, if that fails, falls back
to producing a tree and adding random edges to that tree.

\code{generate_random_cactus} generates a random cactus graph (mostly useful for benchmarking).
}
\seealso{
Other example generation functions:
\code{\link{generate_random_Gamma}()},
\code{\link{generate_random_graphical_Gamma}()},
\code{\link{generate_random_integer_Gamma}()},
\code{\link{generate_random_model}()},
\code{\link{generate_random_spd_matrix}()}
}
\concept{exampleGenerations}
