% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_examples.R
\name{generate_random_model}
\alias{generate_random_model}
\title{Generate random Huesler-Reiss Models}
\usage{
generate_random_model(d, graph_type = "general", ...)
}
\arguments{
\item{d}{Number of vertices in the graph}

\item{graph_type}{\code{"tree"}, \code{"block"}, \code{"decomposable"}, \code{"complete"}, or \code{"general"}}

\item{...}{Further arguments passed to functions generating the graph and Gamma matrix}
}
\description{
Generates a random connected graph and Gamma matrix with conditional independence
structure corresponding to that graph.
}
\examples{
set.seed(1)
d <- 12

generate_random_model(d, 'tree')
generate_random_model(d, 'block')
generate_random_model(d, 'decomposable')
generate_random_model(d, 'general')
generate_random_model(d, 'complete')

}
\seealso{
Other example generation functions:
\code{\link{generate_random_Gamma}()},
\code{\link{generate_random_chordal_graph}()},
\code{\link{generate_random_graphical_Gamma}()},
\code{\link{generate_random_integer_Gamma}()},
\code{\link{generate_random_spd_matrix}()}
}
\concept{exampleGenerations}
