% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yearquarter.R
\name{yearquarter}
\alias{yearquarter}
\title{Constructor for yearquarter objects}
\usage{
yearquarter(year = integer(), quarter = integer())
}
\arguments{
\item{year}{\verb{[integer]}

Vector representing the year associated with \code{quarter}.

\code{double} vectors will be converted via \code{as.integer(floor(x))}.}

\item{quarter}{\verb{[integer]}

Vector representing the quarter associated with `year.

\code{double} vectors will be converted via \code{as.integer(floor(x))}.}
}
\value{
A \verb{<grates_yearquarter>} object.
}
\description{
\code{yearquarter()} is a constructor for \verb{<grates_yearquarter>} objects.
}
\details{
\verb{<grates_yearquarter>} objects are stored as the number of quarters (starting
at 0) since the Unix Epoch (1970-01-01).
}
\examples{
yearquarter(year = 2000L, quarter = 3L)

}
\seealso{
\code{as_yearquarter()} and \code{new_yearquarter()}.
}
