% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isoweek.R
\name{new_isoweek}
\alias{new_isoweek}
\alias{is_isoweek}
\title{Minimal constructor for an isoweek object}
\usage{
new_isoweek(x = integer())

is_isoweek(xx)
}
\arguments{
\item{x}{\verb{[integer]}

Vector representing the number of weeks.

\code{double} vectors will be converted via \code{as.integer(floor(x))}.}

\item{xx}{\R object.}
}
\value{
A \verb{<grates_isoweek>} object.
}
\description{
\code{new_isoweek()} is a constructor for \verb{<grates_isoweek>} objects aimed at
developers.
}
\details{
isoweeks are defined to start on a Monday and \verb{<grates_isoweek>} objects are
stored as the number of weeks (starting at 0) from the first Monday prior to
the Unix Epoch (1970-01-01). That is, the number of seven day periods from
1969-12-29.

Internally they have the same representation as a \verb{<grates_yearweek_monday>}
object so are akin to an alias but with a marginally more efficient
implementation.
}
\examples{
new_isoweek(1:10)

}
\seealso{
\code{new_yearweek()} and \code{new_epiweek()}.
}
