% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utililties.R
\name{model_vars}
\alias{model_vars}
\alias{model_vars.gam}
\alias{model_vars.default}
\alias{model_vars.bam}
\alias{model_vars.gamm}
\alias{model_vars.gamm4}
\alias{model_vars.list}
\title{List the variables involved in a model fitted with a formula}
\usage{
model_vars(model, ...)

\method{model_vars}{gam}(model, ...)

\method{model_vars}{default}(model, ...)

\method{model_vars}{bam}(model, ...)

\method{model_vars}{gamm}(model, ...)

\method{model_vars}{gamm4}(model, ...)

\method{model_vars}{list}(model, ...)
}
\arguments{
\item{model}{a fitted model object with a \verb{$pred.formula}, \verb{$terms}
component or a \code{"terms"} attribute}

\item{...}{Arguments passed to other methods. Currently ignored.}
}
\description{
List the variables involved in a model fitted with a formula
}
\examples{
load_mgcv()

# simulate some Gaussian data
df <- data_sim("eg1", n = 50, seed = 2)

# fit a GAM with 1 smooth and 1 linear term
m1 <- gam(y ~ s(x2, k = 7) + x1, data = df, method = "REML")
model_vars(m1)

# fit a lm with two linear terms
m2 <- lm(y ~ x2 + x1, data = df)
model_vars(m2)
}
