% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose.R
\name{qq_plot}
\alias{qq_plot}
\alias{qq_plot.gam}
\alias{qq_plot.glm}
\title{Quantile-quantile plot of model residuals}
\usage{
qq_plot(model, ...)

\method{qq_plot}{gam}(
  model,
  method = c("direct", "simulate", "normal"),
  type = c("deviance", "response", "pearson"),
  n_uniform = 10,
  n_simulate = 50,
  level = 0.9,
  ylab = NULL,
  xlab = NULL,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  ci_col = "black",
  ci_alpha = 0.2,
  point_col = "black",
  point_alpha = 1,
  line_col = "red",
  ...
)

\method{qq_plot}{glm}(model, ...)
}
\arguments{
\item{model}{a fitted model. Currently only class \code{"gam"}.}

\item{...}{arguments passed ot other methods.}

\item{method}{character; method used to generate theoretical quantiles.}

\item{type}{character; type of residuals to use. Only \code{"deviance"},
\code{"response"}, and \code{"pearson"} residuals are allowed.}

\item{n_uniform}{numeric; number of times to randomize uniform quantiles
in the direct computation method (\code{method = "direct"}).}

\item{n_simulate}{numeric; number of data sets to simulate from the estimated
model when using the simulation method (\code{method = "simulate"}).}

\item{level}{numeric; the coverage level for reference intervals. Must be
strictly \verb{0 < level < 1}. Only used with \code{method = "simulate"}.}

\item{ylab}{character or expression; the label for the y axis. If not
supplied, a suitable label will be generated.}

\item{xlab}{character or expression; the label for the y axis. If not
supplied, a suitable label will be generated.}

\item{title}{character or expression; the title for the plot. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{subtitle}{character or expression; the subtitle for the plot. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{caption}{character or expression; the plot caption. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{ci_col, ci_alpha}{fill colour and alpha transparency for the reference
interval when \code{method = "simulate"}.}

\item{point_col, point_alpha}{colour and alpha transparency for points on the
QQ plot.}

\item{line_col}{colour used to draw the 1:1 reference line.}
}
\description{
Quantile-quantile plot of model residuals
}
\examples{
load_mgcv()
## simulate binomial data...
set.seed(0)
n.samp <- 200
dat <- gamSim(1, n = n.samp, dist = "binary", scale = .33)
p <- binomial()$linkinv(dat$f)               # binomial p
n <- sample(c(1, 3), n.samp, replace = TRUE) # binomial n
dat <- transform(dat, y = rbinom(n, n, p), n = n)
m <- gam( y / n ~ s(x0) + s(x1) + s(x2) + s(x3),
         family = binomial, data = dat, weights = n,
         method = "REML")

## Q-Q plot; default using direct randomization of uniform quantiles
qq_plot(m)

## Alternatively use simulate new data from the model, which
## allows construction of reference intervals for the Q-Q plot
qq_plot(m, method = "simulate", point_col = "steelblue",
        point_alpha = 0.4)

## ... or use the usual normality assumption
qq_plot(m, method = "normal")
}
