% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw-gam.R
\name{draw.gam}
\alias{draw.gam}
\title{Plot estimated smooths from a fitted GAM}
\usage{
\method{draw}{gam}(
  object,
  data = NULL,
  select = NULL,
  parametric = FALSE,
  terms = NULL,
  residuals = FALSE,
  scales = c("free", "fixed"),
  ci_level = 0.95,
  n = 100,
  n_3d = 16,
  n_4d = 4,
  unconditional = FALSE,
  overall_uncertainty = TRUE,
  constant = NULL,
  fun = NULL,
  dist = 0.1,
  rug = TRUE,
  contour = TRUE,
  ci_alpha = 0.2,
  ci_col = "black",
  smooth_col = "black",
  resid_col = "steelblue3",
  contour_col = "black",
  n_contour = NULL,
  partial_match = FALSE,
  discrete_colour = NULL,
  continuous_colour = NULL,
  continuous_fill = NULL,
  position = "identity",
  ncol = NULL,
  nrow = NULL,
  guides = "keep",
  projection = "orthographic",
  orientation = NULL,
  ...
)
}
\arguments{
\item{object}{a fitted GAM, the result of a call to \code{\link[mgcv:gam]{mgcv::gam()}}.}

\item{data}{a optional data frame that may or may not be used? FIXME!}

\item{select}{character, logical, or numeric; which smooths to plot. If
\code{NULL}, the default, then all model smooths are drawn. Numeric \code{select}
indexes the smooths in the order they are specified in the formula and
stored in \code{object}. Character \code{select} matches the labels for smooths
as shown for example in the output from \code{summary(object)}. Logical
\code{select} operates as per numeric \code{select} in the order that smooths are
stored.}

\item{parametric}{logical; plot parametric terms also? Note that \code{select} is
used for selecting which smooths to plot. The \code{terms} argument is used to
select which parametric effects are plotted. The default, as with
\code{\link[mgcv:plot.gam]{mgcv::plot.gam()}}, is to not draw parametyric effects.}

\item{terms}{character; which model parametric terms should be drawn? The
Default of \code{NULL} will plot all parametric terms that can be drawn.}

\item{residuals}{logical; should partial residuals for a smooth be drawn?
Ignored for anything but a simple univariate smooth.}

\item{scales}{character; should all univariate smooths be plotted with the
same y-axis scale? The default, \code{scales = "fixed"}, ensures this is done.
If \code{scales = "free"} each univariate smooth has its own y-axis scale.
Currently does not affect the y-axis scale of plots of the parametric
terms.}

\item{ci_level}{numeric between 0 and 1; the coverage of credible interval.}

\item{n}{numeric; the number of points over the range of the covariate at
which to evaluate the smooth.}

\item{n_3d}{numeric; the number of new observations to generate for the third
dimension of a 3D smooth.}

\item{n_4d}{numeric; the number of new observations to generate for the
dimensions higher than 2 (!) of a \emph{k}D smooth (\emph{k} >= 4). For example, if
the smooth is a 4D smooth, each of dimensions 3 and 4 will get \code{n_4d}
new observations.}

\item{unconditional}{logical; should confidence intervals include the
uncertainty due to smoothness selection? If \code{TRUE}, the corrected Bayesian
covariance matrix will be used.}

\item{overall_uncertainty}{logical; should the uncertainty in the model
constant term be included in the standard error of the evaluate values of
the smooth?}

\item{constant}{numeric; a constant to add to the estimated values of the
smooth. \code{constant}, if supplied, will be added to the estimated value
before the confidence band is computed.}

\item{fun}{function; a function that will be applied to the estimated values
and confidence interval before plotting. Can be a function or the name of a
function. Function \code{fun} will be applied after adding any \code{constant}, if
provided.}

\item{dist}{numeric; if greater than 0, this is used to determine when
a location is too far from data to be plotted when plotting 2-D smooths.
The data are scaled into the unit square before deciding what to exclude,
and \code{dist} is a distance within the unit square. See
\code{\link[mgcv:exclude.too.far]{mgcv::exclude.too.far()}} for further details.}

\item{rug}{logical; draw a rug plot at the botom of each plot?}

\item{contour}{logical; should contours be draw on the plot using
\code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}}.}

\item{ci_alpha}{numeric; alpha transparency for confidence or simultaneous
interval.}

\item{ci_col}{colour specification for the confidence/credible intervals
band. Affects the fill of the interval.}

\item{smooth_col}{colour specification for the smooth line.}

\item{resid_col}{colour specification for the partial residuals.}

\item{contour_col}{colour specification for contour lines.}

\item{n_contour}{numeric; the number of contour bins. Will result in
\code{n_contour - 1} contour lines being drawn. See \code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}}.}

\item{partial_match}{logical; should smooths be selected by partial matches
with \code{select}? If \code{TRUE}, \code{select} can only be a single string to match
against.}

\item{discrete_colour, continuous_colour, continuous_fill}{suitable scales
for the types of data.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{ncol, nrow}{numeric; the numbers of rows and columns over which to
spread the plots}

\item{guides}{character; one of \code{"keep"} (the default), \code{"collect"}, or
\code{"auto"}. Passed to \code{\link[patchwork:plot_layout]{patchwork::plot_layout()}}}

\item{projection}{character; projection to use, see \code{\link[mapproj:mapproject]{mapproj::mapproject()}}
for a list.}

\item{orientation}{an optional vector \code{c(latitude, longitude, rotation)}
which describes where the "North Pole" should be when computing the
projection. The third value is a clockwise rotation (in degrees), which
defaults to the midrange of the longitude coordinates in the data. The
default values for \code{orientation} therefore are
`c(20, 0, mean(range(longitude))))`` if this is not specified by the user.
See \code{\link[mapproj:mapproject]{mapproj::mapproject()}} for more information.}

\item{...}{additional arguments passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.}
}
\value{
The object returned is created by \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.
}
\description{
Plots estimated smooths from a fitted GAM model in a similar way to
\code{mgcv::plot.gam()} but instead of using base graphics, \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
is used instead.
}
\note{
Internally, plots of each smooth are created using \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
and composed into a single plot using \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}. As a
result, it is not possible to use \code{+} to add to the plots in the way one
might typically work with \code{ggplot()} plots. Instead, use the \code{&} operator;
see the examples.
}
\examples{
load_mgcv()

# simulate some data
df1 <- data_sim("eg1", n = 400, dist = "normal", scale = 2, seed = 2)
# fit GAM
m1 <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = df1, method = "REML")

# plot all smooths
draw(m1)

# can add partial residuals
draw(m1, residuals = TRUE)

df2 <- data_sim(2, n = 1000, dist = "normal", scale = 1, seed = 2)
m2 <- gam(y ~ s(x, z, k = 40), data = df2, method = "REML")
draw(m2, contour = FALSE, n = 50)

# change the number of contours drawn and the fill scale used for
# the surface
library("ggplot2")
draw(m2, n_contour = 5, n = 50,
     continuous_fill = scale_fill_distiller(palette = "Spectral",
                                            type = "div"))

# to modify all panels, for example to change the theme, use the & operator
draw(m2, n_contour = 5, n = 50) &
  theme_minimal()

# customising some plot elements
draw(m1, ci_col = "steelblue", smooth_col = "forestgreen", ci_alpha = 0.3)
}
\author{
Gavin L. Simpson
}
