% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variance-components.R
\name{variance_comp}
\alias{variance_comp}
\alias{variance_comp.gam}
\title{Variance components of smooths from smoothness estimates}
\usage{
variance_comp(object, ...)

\method{variance_comp}{gam}(object, rescale = TRUE, coverage = 0.95, ...)
}
\arguments{
\item{object}{an R object. Currently only models fitted by \code{\link[mgcv:gam]{mgcv::gam()}} or
\code{\link[mgcv:bam]{mgcv::bam()}} are supported.}

\item{...}{arguments passed to other methods}

\item{rescale}{logical; for numerical stability reasons the penalty matrices
of smooths are rescaled before fitting. If \code{rescale = TRUE}, this rescaling
is undone, resulting in variance components that are on their original
scale. This is needed if comparing with other mixed model software, such as
\code{lmer()}.}

\item{coverage}{numeric; a value between 0 and 1 indicating the (approximate)
coverage of the confidence interval that is returned.}
}
\description{
A wrapper to \code{\link[mgcv:gam.vcomp]{mgcv::gam.vcomp()}} which returns the smoothing parameters
expressed as variance components.
}
\details{
This function is a wrapper to \code{\link[mgcv:gam.vcomp]{mgcv::gam.vcomp()}} which performs
three additional services
\itemize{
\item it suppresses the annoying text output that \code{\link[mgcv:gam.vcomp]{mgcv::gam.vcomp()}} prints to
the terminal,
\item returns the variance of each smooth as well as the standard deviation, and
\item returns the variance components as a tibble.
}
}
