% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametric-effects.R
\name{parametric_effects}
\alias{parametric_effects}
\alias{parametric_effects.gam}
\title{Estimated values for parametric model terms}
\usage{
parametric_effects(object, ...)

\method{parametric_effects}{gam}(
  object,
  terms = NULL,
  unconditional = FALSE,
  unnest = TRUE,
  ci_level = 0.95,
  envir = environment(formula(object)),
  ...
)
}
\arguments{
\item{object}{a fitted model object.}

\item{...}{arguments passed to other methods.}

\item{terms}{character; which model parametric terms should be drawn? The
Default of \code{NULL} will plot all parametric terms that can be drawn.}

\item{unconditional}{logical; should confidence intervals include the
uncertainty due to smoothness selection? If \code{TRUE}, the corrected Bayesian
covariance matrix will be used.}

\item{unnest}{logical; unnest the smooth objects?}

\item{ci_level}{numeric; the coverage required for the confidence interval.
Currently ignored.}

\item{envir}{an environment to look up the data within.}
}
\description{
Estimated values for parametric model terms
}
