% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{pi_coefficients}
\alias{pi_coefficients}
\title{Compute pi coefficients of an AR process from SARIMA coefficients.}
\usage{
pi_coefficients(
  ar = 0,
  d = 0L,
  ma = 0,
  sar = 0,
  D = 0L,
  sma = 0,
  m = 1L,
  tol = 1e-07
)
}
\arguments{
\item{ar}{AR coefficients in the SARIMA model.}

\item{d}{number of differences in the SARIMA model.}

\item{ma}{MA coefficients in the SARIMA model.}

\item{sar}{seasonal AR coefficients in the SARIMA model.}

\item{D}{number of seasonal differences in the SARIMA model.}

\item{sma}{seasonal MA coefficients in the SARIMA model.}

\item{m}{seasonal period in the SARIMA model.}

\item{tol}{tolerance value used. Only return up to last element greater than tolerance.}
}
\value{
A vector of AR coefficients.
}
\description{
Convert SARIMA coefficients to pi coefficients of an AR process.
}
\examples{
# Not Run
}
\author{
Rob J Hyndman
}
