% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_ts_with_target.R
\name{generate_ts_with_target}
\alias{generate_ts_with_target}
\title{Generating time series with controllable features.}
\usage{
generate_ts_with_target(
  n,
  ts.length,
  freq,
  seasonal,
  features,
  selected.features,
  target,
  parallel = TRUE,
  output_format = "list"
)
}
\arguments{
\item{n}{number of time series to be generated.}

\item{ts.length}{length of the time series to be generated.}

\item{freq}{frequency of the time series to be generated.}

\item{seasonal}{0 for non-seasonal data, 1 for single-seasonal data, and 2 for multiple seasonal data.}

\item{features}{a vector of function names.}

\item{selected.features}{selected features to be controlled.}

\item{target}{target feature values.}

\item{parallel}{An optional argument which allows to specify if the Genetic Algorithm
should be run sequentially or in parallel.}

\item{output_format}{An optional argument which allows to choose output format between 'list' and 'tsibble'}
}
\value{
A time-series object of class "ts" or "msts".
}
\description{
Deprecated function. Please use \code{\link{generate_target}()} instead.
}
\examples{
library(tsfeatures)
x <- generate_ts_with_target(
  n = 1, ts.length = 60, freq = 1, seasonal = 0,
  features = c("entropy", "stl_features"), selected.features = c("entropy", "trend"),
  target = c(0.6, 0.9), parallel = FALSE
)
forecast::autoplot(x)
}
\author{
Yanfei Kang
}
