% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medicare_levy.R
\name{medicare_levy}
\alias{medicare_levy}
\title{Medicare levy}
\usage{
medicare_levy(income, fy.year = "2013-14", Spouse_income = 0,
  sapto.eligible = FALSE, sato = NULL, pto = NULL,
  family_status = "individual", n_dependants = 0, .checks = TRUE)
}
\arguments{
\item{income}{The taxable income. A vector of numeric values.}

\item{fy.year}{The financial year. A character vector satisfying \code{is.fy}.}

\item{Spouse_income}{The spouse's adjusted income.}

\item{sapto.eligible}{(logical) Is the taxpayer eligible for SAPTO? See Details.}

\item{sato}{Is the taxpayer eligible for the Senior Australians Tax Offset?}

\item{pto}{Is the taxpayer eligible for the Pensions Tax Offset?}

\item{family_status}{What is the taxpayer's family status: family or individual?}

\item{n_dependants}{Number of children dependant on the taxpayer.}

\item{.checks}{Should checks of certain arguments be made? Provided to improve performance when checks are not necessary.}
}
\value{
The Medicare levy payable for that taxpayer.
}
\description{
The (actual) amount payable for the Medicare levy.
}
\details{
The Medicare levy for individuals is imposed by the \emph{Medicare Levy Act 1986} (Cth).
The function only calculates the levy for individuals (not trusts).
It includes the s 7 \emph{Levy in cases of small incomes}, including the differences for those
eligible for \code{\link{sapto}}.
s 8 \emph{Amount of levy---person who has spouse or dependants} (though the number of dependants
is not a variable in the sample files).

The function does \strong{not} include the Medicare levy surcharge; it assumes that all 
persons (who would potentially be liable for it) avoided it.#' 

The Seniors and Pensioners Tax Offset was formed in 2012-13 as an amalgam of the Senior Australians Tax Offset and the Pensions Tax Offset. 
Medicare rates before 2012-13 were different based on these offsets. 
For most taxpayers, eligibility would be based on whether your age is over the pension age (currently 65).
If \code{sato} and \code{pto} are \code{NULL}, \code{sapto.eligible} stands for eligibility for the \code{sato} and not \code{pto}.
If \code{sato} or \code{pto} are not \code{NULL} for such years, only \code{sato} is currently considered. 
Supplying \code{pto} independently is currently a warning.

See \url{http://classic.austlii.edu.au/au/legis/cth/consol_act/mla1986131/}
for the \emph{Medicare Levy Act 1986} (Cth).
}
